﻿var card_index;
var language;
var userName;
/* function to get the card slot and status value*/
function GetERMInfo()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();

	var getParams = "type=24&cmd=1&card=" + card_index + "language=" + language;

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var ERMDisplay = xmlhttp.responseText.slice(7, -8).split("&");
			var count = 0;
			
			document.getElementById("update_bandwidth").value = ERMDisplay[count++];
			document.getElementById("routing_cost").value = ERMDisplay[count++];
			document.getElementById("r6_rtsp_port").value = ERMDisplay[count++];
			document.getElementById("erm_alive").value = ERMDisplay[count++];
			document.getElementById("retry_time").value = ERMDisplay[count++];
			document.getElementById("hold_time").value = ERMDisplay[count++];
			document.getElementById("vod_architecture").value = ERMDisplay[count++];
			
			document.getElementById("erm_ip_addr").value = ERMDisplay[count++];
			document.getElementById("erm_udp_port").value = ERMDisplay[count++];
			document.getElementById("erm_stream_zone").value = ERMDisplay[count++];
			document.getElementById("erm_enable").value = ERMDisplay[count++]; 
			if(document.getElementById("erm_enable").value == 1)
			{
				document.getElementById("erm_enable").checked = true;
			}
			else
			{
				document.getElementById("erm_enable").checked = false;
			}
			if(ERMDisplay[count++] == 0)
			{
				if(language == 0)
				{
					document.getElementById("erm_state").innerHTML = "NO CONNECT";
				}
				else
				{
					document.getElementById("erm_state").innerHTML = "未连接";
				}
			}
			else
			{
				if(language == 0)
				{
					document.getElementById("erm_state").innerHTML = "CONNECT";
				}
				else
				{
					document.getElementById("erm_state").innerHTML = "已连接";
				}
			}

			document.body.style.cursor = "auto";
			window.status = "Done";
		}
	}
	xmlhttp.send(getParams);
	return false;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	DisableApply();
	GetERMInfo();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	var group = args["group"];
	userName = args["userName"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	card_index = parseInt(nodeId);
	language = document.getElementById("language").value;
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	PageLoadHandler();
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function CheckBandwidth(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Bandwidth.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的带宽。");  
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 1000000))
	{
		if(language == 0)
		{
			alert("Valid range for Bandwidth is 0 - 1000000.");
		}
		else
		{
			alert("带宽的范围是0 - 1000000。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}

function checkRouterNum(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Routing Cost.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的路由数。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 255))
	{
		if(language == 0)
		{
			alert("Valid range for Routing Cost is 0 - 255.");
		}
		else
		{
			alert("路由数的范围是0 - 255。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}

function CheckPortNum(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for RTSP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的RTSP端口。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for RTSP Port is 0 - 65535.");
		}
		else
		{
			alert("RTSP端口的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}

function CheckTime(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Check Time.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的时间。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Check Time is 0 - 65535.");
		}
		else
		{
			alert("时间的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function CheckIP(obj)
{
	if(Validate_IP_Format(obj.value) == false)
	{	
		if(language == 0)
		{
			alert("Invalid IP address. Please enter a valid IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function CheckStreamZone(obj)
{
	var stream_zone = obj.value;	
	if(stream_zone == "")
	{
		if(language == 0)
		{
			alert("The streaming zone is empty.");
		}
		else
		{
			alert("时区是空的。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function validateErmEnable(erm_enable, erm_ip_addr)
{
	if(erm_ip_addr.value == "0.0.0.0")
	{
		if(erm_enable.checked == true)
		{
			if(language == 0)
			{
				alert("Please input a valid IP Adderss when ERM is enabled!");
			}
			else
			{
				alert("ERM使能时，请输入非零的IP地址！");
			}
			return false;
		}
	}
	return true;
}

function checkErmEnable()
{
	var erm_ip_addr = document.getElementById("erm_ip_addr");
	var erm_enable = document.getElementById("erm_enable");
	
	if(!validateErmEnable(erm_enable, erm_ip_addr))
	{
		erm_enable.checked = false;
		return false;
	}
}

function validateAllInput()
{
	comp = document.getElementById("update_bandwidth");
	if(CheckBandwidth(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("routing_cost");
	if(checkRouterNum(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("r6_rtsp_port");
	if(CheckPortNum(comp) == false)
	{
		return false;
	}
	
	var contorlName = new Array("erm_alive", "retry_time", "hold_time");
	for(var i = 0; i < contorlName.length; i++)
	{
		comp = document.getElementById(contorlName[i]);
		if(CheckTime(comp) == false)
		{
			return false;
		}
	}
	
	comp = document.getElementById("erm_ip_addr");
	if(CheckIP(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("erm_udp_port");
	if(CheckPortNum(comp) == false)
	{
		return false;
	}
	
	comp = document.getElementById("erm_stream_zone");
	if(CheckStreamZone(comp) == false)
	{
		return false;
	}
	
	var erm_ip_addr = document.getElementById("erm_ip_addr");
	var erm_enable = document.getElementById("erm_enable");
	if(!validateErmEnable(erm_enable, erm_ip_addr))
	{
		setTimeout(function () {erm_ip_addr.focus()}, 50);
		erm_ip_addr.select();
		return false;
	}
	return true;
}

function GenarateERMInfo()
{
	var Params = "";
	var update_bandwidth = document.getElementById("update_bandwidth").value;
	Params = Params + "&update_bandwidth=" + update_bandwidth;
	
	var routing_cost = document.getElementById("routing_cost").value;
	Params = Params + "&routing_cost=" + routing_cost;
	
	var r6_rtsp_port = document.getElementById("r6_rtsp_port").value;
	Params = Params + "&r6_rtsp_port=" + r6_rtsp_port;

	var erm_alive = document.getElementById("erm_alive").value;
	Params = Params + "&erm_alive=" + erm_alive;

	var retry_time = document.getElementById("retry_time").value;
	Params = Params + "&retry_time=" + retry_time;

	var hold_time = document.getElementById("hold_time").value;
	Params = Params + "&hold_time=" + hold_time;

	var vod_architecture = document.getElementById("vod_architecture").value;
	Params = Params + "&vod_architecture=" + vod_architecture;

	var erm_ip_addr = document.getElementById("erm_ip_addr").value;
	Params = Params + "&erm_ip_addr=" + erm_ip_addr;
	
	var erm_udp_port = document.getElementById("erm_udp_port").value;
	Params = Params + "&erm_udp_port=" + erm_udp_port;

	var erm_stream_zone = document.getElementById("erm_stream_zone").value;
	Params = Params + "&erm_stream_zone=" + erm_stream_zone;
	
	if(document.getElementById("erm_enable").checked == true)
	{
		document.getElementById("erm_enable").value = 1;
	}
	else
	{
		document.getElementById("erm_enable").value = 0;
	}
	var erm_enable = document.getElementById("erm_enable").value;
	Params = Params + "&erm_enable=" + erm_enable;
	return Params;
}

function SetERMInfo()
{
	var getParams = "type=24&cmd=2&userName" + userName + "&card=" + card_index;
	getParams = getParams + GenarateERMInfo();
	
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Card ERM Configuration Updated Successfully");
			}
			else
			{
				alert("卡ERM参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetERMConfiguration()
{
	if(validateAllInput() != true)
	{
		return false;
	}
	
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating card information, please wait...";
	SetERMInfo();		
}
